package com.woodwing.core.vo.webapps {

	/**
	 * SubAppDescriptorVO is a blueprint of the ApplicationDescriptor file used for sub applications
	 *
	 * @author     Edwin van der Ven
	 * @since       v7.1
	 * @copyright	Woodwing Software bv. All Rights Reserved.
	 **/
	public class SubAppDescriptorVO {

		public var name:String; // name of the application
		public var path:String; //Path of the application can be URI or URL 
		public var file:String; // Filename of the application
		public var type:String; // type of application (application or module)
		public var flexSDK:String; // flexSDK version
		public var airSDK:String; // airSDK version
		public var icon:String; // icon location
		public var sandbox:Boolean; // checks the security domain
		public var allowMultipleInstances:Boolean;
		public var numberInList:int; // the counter in which order the applications should be added to the application tab

		public function SubAppDescriptorVO (name:String = "", path:String = "", file:String = "", type:String = "", flexSDK:String = "", airSDK:String = "", icon:String = "", sandbox:Boolean = true, allowMultipleInstances:Boolean = true, numberInList:int = 0) {
			this.name = name;
			this.path = path;
			this.file = file;
			//Deprecated allways use application, modules are no longer supported
			//this.type = type; 
			this.type = "application";
			this.flexSDK = flexSDK;
			this.airSDK = airSDK;
			this.icon = icon;
			this.sandbox = sandbox;
			this.allowMultipleInstances = allowMultipleInstances;
			this.numberInList = numberInList;
		}

	}
}

