package com.woodwing.core.model {

	import flash.events.Event;
	import flash.events.EventDispatcher;

	import mx.collections.ArrayCollection;
	import mx.core.Application;
	import mx.core.UIComponent;
	import mx.events.SWFBridgeRequest;
	import mx.logging.ILogger;
	import mx.logging.LogEventLevel;
	import mx.rpc.events.ResultEvent;

	/**
	 * ContentStationAPIBridge is the class that permits the ContentStationAPI to interact with ContentStation.
	 * It listens to the event on the same EventDispatcher than the API and therefore the subapplications (running within ContentStation)
	 *
	 * Note: The close session functions are not implemented in the simulator
	 *
	 * @author     Gaelle Meheut
	 * @since       v7.1
	 * @copyright	Woodwing Software bv. All Rights Reserved.
	 **/

	public class ContentStationAPIBridge {

		//The event dispatcher shared with the ContentStationAPI and subbaplications
		public var sharedEvents:EventDispatcher;

		//list of Events that can be dispatched by the ContentStationAPI
		public static const CS_API_GET_TICKET:String = "CS_API_GetTicket";
		public static const CS_API_GET_USERNAME:String = "CS_API_GetUsername";
		public static const CS_API_GET_SERVERURL:String = "CS_API_GetServerUrl";
		public static const CS_API_DEBUG:String = "CS_API_Debug";
		public static const CS_API_SESSION_CLOSING:String = "CS_API_Session_Closing";
		public static const CS_API_CLOSE_SESSION:String = "CS_API_Close_Session";
		public static const CS_API_CANCEL_CLOSE_SESSION:String = "CS_API_Cancel_Close_Session";
		public static const CS_API_TAB_CLOSE_CANCELED:String = "CS_API_Tab_Close_Canceled";
		public static const CLEAR_ALL_LISTENERS:String = "CS_API_Clear_All_Listeners";
		public static const CS_API_GET_BASEPATH:String = "CS_API_GetBasePath";
		public static const CS_API_OPEN_SMARTOBJECT:String = "CS_API_OpenSmartObject";
		public static const CS_API_GET_SETTING:String = "CS_API_GetSetting";
		public static const CS_API_GET_CONFIGSETTING:String = "CS_API_GetConfigSetting";

		private var isClosing:Boolean = false; //ignoredCloseEvent
		private var isHandlingCloseEvent:Boolean = false;
		private var sessionClosingReason:String;
		private var basePath:String;


		[Bindable] public var logText:String = "";

		/**
		 * Constructor
		 * The apiDispatcher should be the same for subApplications and ContentStation.
		 * As the subApplications are opened within ContentStation, the 2 applications are sharing the same system Manager and sharedEvents.
		 *
		 * @param	sharedEvents EventDispatcher :
		 **/
		public function ContentStationAPIBridge (sharedEvents:EventDispatcher, basePath:String):void {
			this.sharedEvents = sharedEvents;
			this.basePath = basePath;
			//suscribed to events that can be dispatched by the ContentStationAPI
			sharedEvents.addEventListener(CS_API_GET_TICKET, getTicket);
			sharedEvents.addEventListener(CS_API_GET_USERNAME, getUsername);
			sharedEvents.addEventListener(CS_API_GET_SERVERURL, getServerUrl);
			sharedEvents.addEventListener(CS_API_DEBUG, debugFromExternApp);
			sharedEvents.addEventListener(CS_API_GET_BASEPATH, getBasePath);
			sharedEvents.addEventListener(CS_API_OPEN_SMARTOBJECT, openSmartObject);
			sharedEvents.addEventListener(CS_API_GET_CONFIGSETTING, getConfigSetting);
		}


		/**
		 * Function that permits returning the ContentStation ticket.
		 *
		 * @return ticket String
		 * @param event has no Type otherwise it would failed in the case of a Subapplication sandboxed loaded in CS
		 **/
		private function getTicket (event:*):void {
			log("getTicket");
			event.data = "Ticket";
		}


		/**
		 * Function that permits returning the username.
		 *
		 * @return username String
		 * @param event has no Type otherwise it would failed in the case of a Subapplication sandboxed loaded in CS
		 * **/
		private function getUsername (event:*):void {
			log("getUsername");
			event.data = "UserName";
		}


		/**
		 * Function that permits returning the server url.
		 *
		 * @return server url String
		 * @param event has no Type otherwise it would failed in the case of a Subapplication sandboxed loaded in CS
		 **/
		private function getServerUrl (event:*):void {
			log("getServerUrl");
			event.data = "Server URL";
		}

		/**
		 * Function that permits returning the base path of the module
		 * @return base path of the module String
		 * @param event has no Type otherwise it would failed in the case of a Subapplication sandboxed loaded in CS
		 **/
		private function getBasePath (event:*):void {
			log("getBasePath");
			event.data = this.basePath;
		}



		/**
		 * Function that permits display debug log.
		 *
		 **/
		private function debugFromExternApp (event:*):void {
			switch (event.data[1]) {
				case LogEventLevel.FATAL:
					log("[SubApp] FATAL " + event.data[0]);
					break;

				case LogEventLevel.ERROR:
					log("[SubApp] ERROR " + event.data[0]);
					break;

				case LogEventLevel.WARN:
					log("[SubApp] WARN " + event.data[0]);
					break;

				case LogEventLevel.INFO:
					log("[SubApp] INFO " + event.data[0]);
					break;

				case LogEventLevel.DEBUG:
					log("[SubApp] DEBUG " + event.data[0]);
					break;

				case LogEventLevel.ALL:
					log("[SubApp] ALL " + event.data[0]);
					break;

				default:
					log("[SubApp] " + event.data[0]);
					break;
			}


		}

		/**
		 * Function that permits openSmartObject.
		 *
		 **/
		private function openSmartObject (event:*):void {

			var objectID:String = event.data[0];

			log("openSmartObject " + objectID);
		}

		/**
		 * cancel the session closing. The close event is not handled anymore.
		 *
		 **/
		public function clearAllListeners ():void {
			log("clearAllListeners");
			sharedEvents.removeEventListener(CS_API_GET_TICKET, getTicket);
			sharedEvents.removeEventListener(CS_API_GET_USERNAME, getUsername);
			sharedEvents.removeEventListener(CS_API_GET_SERVERURL, getServerUrl);
			sharedEvents.removeEventListener(CS_API_DEBUG, debugFromExternApp);
			sharedEvents.removeEventListener(CS_API_GET_BASEPATH, getBasePath);
			sharedEvents.removeEventListener(CS_API_OPEN_SMARTOBJECT, openSmartObject);
			sharedEvents.removeEventListener(CS_API_GET_CONFIGSETTING, getConfigSetting);


			var requestClearAllListeners:SWFBridgeRequest = new SWFBridgeRequest(CLEAR_ALL_LISTENERS);
			this.sharedEvents.dispatchEvent(requestClearAllListeners);
		}

		/**
		 * Function that permits returning a setting from the ContentStation Area in WWSettings
		 * @return value of the settings
		 * @param event has no Type otherwise it would failed in the case of a Subapplication sandboxed loaded in CS
		 **/
		private function getConfigSetting (event:*):void {
			log("getConfigSetting");
			var name:String = event.data[0];

			event.data = "ConfigSetting";
		}


		private function log (text:String):void {
			if (logText != "") {
				logText = logText + "\n";
			}
			logText = logText + text;
		}
	}
}

